/** @file   GuardianTank.h
 * @brief   Declaration of GuardianTank class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/03/29 22:25:47 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_GUARDIANTANK_H
#define H_WWW_GUARDIANTANK_H

#include "GameObject.h"

namespace WeWantWar {

/** @class  GuardianTank
 * @brief   An alien tank.
 * @author  Tomi Lamminsaari
 *
 */
class GuardianTank : public GameObject
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================
  
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  GuardianTank( const std::string& aRoute );

  /** Destructor
   */
  virtual ~GuardianTank();

private:
  GuardianTank( const GuardianTank& aAnother );
  GuardianTank& operator= ( const GuardianTank& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   */
  virtual bool reloading() const;

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================

  static const int KGunNose1 = 0;
  static const int KGunNose2 = 1;
  static const int KReloadCounter = 0;
  
  /** Makes this tank to shoot.
   */
  void shoot();

protected:
  ///
  /// Data members
  /// ============
  
  /** Moving speed. */
  float iForwardVelocity;
  /** Uid of the tank's graphics. */
  int iGraphicUid;
  /** Pointer to positional soundsource object. */
  eng2d::SoundSource* iSoundSource;
};

};  // end of namespace

#endif
